{========================================================================}
{=                (c) 1995-98 SwiftSoft Ronald Dittrich                 =}
{========================================================================}
{=                          All Rights Reserved                         =}
{========================================================================}
{=  D 01099 Dresden             = Fax.: +49(0)351-8037944               =}
{=  Loewenstr.7a                = info@swiftsoft.de                     =}
{========================================================================}
{=  Actual versions on http://www.swiftsoft.de/index.html               =}
{========================================================================}
{=  This code is for reference purposes only and may not be copied or   =}
{=  distributed in any format electronic or otherwise except one copy   =}
{=  for backup purposes.                                                =}
{=                                                                      =}
{=  No Delphi Component Kit or Component individually or in a collection=}
{=  subclassed or otherwise from the code in this unit, or associated   =}
{=  .pas, .dfm, .dcu, .asm or .obj files may be sold or distributed     =}
{=  without express permission from SwiftSoft.                          =}
{=                                                                      =}
{=  For more licence informations please refer to the associated        =}
{=  HelpFile.                                                           =}
{========================================================================}
{=  $Date: 13.11.98 - 14:45:37 $                                        =}
{========================================================================}
unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, MMWave,MMDSMix, MMObj, ComCtrls, Buttons, ExtCtrls, MMButton,
  MMCstDlg, MMDesign, MMPanel, MMConect, MMWavIn, MMDIBCv, MMLevel,
  MMDSPObj, MMHook, MMGauge, MMCCon, MMDSCon;

type
  TMainForm = class(TForm)
    Panel1: TPanel;
    btnPause1: TMMSpeedButton;
    btnPlay1: TMMSpeedButton;
    lblName1: TLabel;
    btnStop1: TMMSpeedButton;
    btnMute1: TMMSpeedButton;
    btnLoop1: TMMSpeedButton;
    Label2: TLabel;
    Label3: TLabel;
    Label4: TLabel;
    btnLoad1: TMMSpeedButton;
    btnAuto1: TMMSpeedButton;
    trackPosition1: TTrackBar;
    trackVolume1: TTrackBar;
    trackFreq1: TTrackBar;
    trackPan1: TTrackBar;
    Panel2: TPanel;
    btnPause2: TMMSpeedButton;
    btnPlay2: TMMSpeedButton;
    lblName2: TLabel;
    btnStop2: TMMSpeedButton;
    btnMute2: TMMSpeedButton;
    btnLoop2: TMMSpeedButton;
    Label10: TLabel;
    Label11: TLabel;
    Label12: TLabel;
    btnLoad2: TMMSpeedButton;
    btnAuto2: TMMSpeedButton;
    trackPosition2: TTrackBar;
    trackVolume2: TTrackBar;
    trackFreq2: TTrackBar;
    trackPan2: TTrackBar;
    Panel3: TPanel;
    btnPause3: TMMSpeedButton;
    btnPlay3: TMMSpeedButton;
    lblName3: TLabel;
    btnStop3: TMMSpeedButton;
    btnMute3: TMMSpeedButton;
    btnLoop3: TMMSpeedButton;
    Label14: TLabel;
    Label15: TLabel;
    Label16: TLabel;
    btnLoad3: TMMSpeedButton;
    btnAuto3: TMMSpeedButton;
    trackPosition3: TTrackBar;
    trackVolume3: TTrackBar;
    trackFreq3: TTrackBar;
    trackPan3: TTrackBar;
    Panel4: TPanel;
    btnPause4: TMMSpeedButton;
    btnPlay4: TMMSpeedButton;
    lblName4: TLabel;
    btnStop4: TMMSpeedButton;
    btnMute4: TMMSpeedButton;
    btnLoop4: TMMSpeedButton;
    Label18: TLabel;
    Label19: TLabel;
    Label20: TLabel;
    btnLoad4: TMMSpeedButton;
    btnAuto4: TMMSpeedButton;
    trackPosition4: TTrackBar;
    trackVolume4: TTrackBar;
    trackFreq4: TTrackBar;
    trackPan4: TTrackBar;
    Panel5: TPanel;
    btnPause5: TMMSpeedButton;
    btnPlay5: TMMSpeedButton;
    lblName5: TLabel;
    btnStop5: TMMSpeedButton;
    btnMute5: TMMSpeedButton;
    btnLoop5: TMMSpeedButton;
    Label22: TLabel;
    Label23: TLabel;
    Label24: TLabel;
    btnLoad5: TMMSpeedButton;
    btnAuto5: TMMSpeedButton;
    trackPosition5: TTrackBar;
    trackVolume5: TTrackBar;
    trackFreq5: TTrackBar;
    trackPan5: TTrackBar;
    Channel1: TMMDSMixChannel;
    Channel2: TMMDSMixChannel;
    Channel3: TMMDSMixChannel;
    Channel4: TMMDSMixChannel;
    Channel5: TMMDSMixChannel;
    MMWaveOpenDialog: TMMWaveOpenDialog;
    Timer1: TTimer;
    WaveMixer: TMMDSWaveMixer;
    MMDesigner1: TMMDesigner;
    MMLevel1: TMMLevel;
    MMLevel2: TMMLevel;
    MMLevel3: TMMLevel;
    MMLevel4: TMMLevel;
    MMLevel5: TMMLevel;
    MMDSChannelConnector1: TMMDSChannelConnector;
    MMDSChannelConnector2: TMMDSChannelConnector;
    MMDSChannelConnector3: TMMDSChannelConnector;
    MMDSChannelConnector4: TMMDSChannelConnector;
    MMDSChannelConnector5: TMMDSChannelConnector;
    procedure btnPlayClick(Sender: TObject);
    procedure btnStopClick(Sender: TObject);
    procedure btnPauseClick(Sender: TObject);
    procedure btnLoadClick(Sender: TObject);
    procedure btnMuteClick(Sender: TObject);
    procedure btnLoopClick(Sender: TObject);
    procedure trackVolumeChange(Sender: TObject);
    procedure trackPanChange(Sender: TObject);
    procedure trackFreqChange(Sender: TObject);
    procedure trackPositionChange(Sender: TObject);
    procedure Timer1Timer(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure PlayEnd(Sender: TObject);
    procedure btnAutoClick(Sender: TObject);
  private
    { Private-Deklarationen }
  public
    { Public-Deklarationen }
  end;

var
  MainForm: TMainForm;

implementation

{$R *.DFM}

{-- TMainForm -----------------------------------------------------------}
procedure TMainForm.FormCreate(Sender: TObject);
begin
   if not Channel1.Wave.Empty then
   begin
      lblName1.Caption := 'Wave1';
      trackPosition1.Position := 0;
      trackPosition1.Max := Channel1.BufferLength;
      trackPosition1.PageSize := trackPosition1.Max div 10;
   end;
   if not Channel2.Wave.Empty then
   begin
      lblName2.Caption := 'Wave2';
      trackPosition2.Position := 0;
      trackPosition2.Max := Channel2.BufferLength;
      trackPosition2.PageSize := trackPosition2.Max div 10;
   end;
   if not Channel3.Wave.Empty then
   begin
      lblName3.Caption := 'Wave3';
      trackPosition3.Position := 0;
      trackPosition3.Max := Channel3.BufferLength;
      trackPosition3.PageSize := trackPosition3.Max div 10;
   end;
   if not Channel4.Wave.Empty then
   begin
      lblName4.Caption := 'Wave4';
      trackPosition4.Position := 0;
      trackPosition4.Max := Channel4.BufferLength;
      trackPosition4.PageSize := trackPosition4.Max div 10;
   end;
   if not Channel5.Wave.Empty then
   begin
      lblName5.Caption := 'Wave5';
      trackPosition5.Position := 0;
      trackPosition5.Max := Channel5.BufferLength;
      trackPosition5.PageSize := trackPosition5.Max div 10;
   end;
end;

{-- TMainForm -----------------------------------------------------------}
procedure TMainForm.btnLoadClick(Sender: TObject);
var
   FileName: TFileName;

begin
   if MMWaveOpenDialog.Execute then
   begin
      FileName := MMWaveOpenDialog.FileName;
      case TMMSpeedButton(Sender).Tag of
           1: begin
                 Channel1.Wave.FileName := FileName;
                 lblName1.Caption := ExtractFileName(FileName);
                 trackPosition1.Position := 0;
                 trackPosition1.Max := Channel1.BufferLength div 1024;
                 trackPosition1.PageSize := trackPosition1.Max div 10;
              end;
           2: begin
                 Channel2.Wave.FileName := FileName;
                 lblName2.Caption := ExtractFileName(FileName);
                 trackPosition2.Position := 0;
                 trackPosition2.Max := Channel2.BufferLength div 1024;
                 trackPosition2.PageSize := trackPosition2.Max div 10;
              end;
           3: begin
                 Channel3.Wave.FileName := FileName;
                 lblName3.Caption := ExtractFileName(FileName);
                 trackPosition3.Position := 0;
                 trackPosition3.Max := Channel3.BufferLength div 1024;
                 trackPosition3.PageSize := trackPosition3.Max div 10;
              end;
           4: begin
                 Channel4.Wave.FileName := FileName;
                 lblName4.Caption := ExtractFileName(FileName);
                 trackPosition4.Position := 0;
                 trackPosition4.Max := Channel4.BufferLength div 1024;
                 trackPosition4.PageSize := trackPosition4.Max div 10;
              end;
           5: begin
                 Channel5.Wave.FileName := FileName;
                 lblName5.Caption := ExtractFileName(FileName);
                 trackPosition5.Position := 0;
                 trackPosition5.Max := Channel5.BufferLength div 1024;
                 trackPosition5.PageSize := trackPosition5.Max div 10;
              end;
      end;
   end;
end;

{-- TMainForm -----------------------------------------------------------}
procedure TMainForm.PlayEnd(Sender: TObject);
begin
   if csDestroying in ComponentState then exit;
   
   case TMMDSMixChannel(Sender).Tag of
        1: begin
              btnPlay1.Down := False;
              if btnAuto1.Down then btnPlayClick(btnPlay2);
           end;
        2: begin
              btnPlay2.Down := False;
              if btnAuto2.Down then btnPlayClick(btnPlay3);
           end;
        3: begin
              btnPlay3.Down := False;
              if btnAuto3.Down then btnPlayClick(btnPlay4);
           end;
        4: begin
              btnPlay4.Down := False;
              if btnAuto4.Down then btnPlayClick(btnPlay5);
           end;
        5: begin
              btnPlay5.Down := False;
              if btnAuto5.Down then btnPlayClick(btnPlay1);
           end;
   end;
end;

{-- TMainForm -----------------------------------------------------------}
procedure TMainForm.btnPlayClick(Sender: TObject);
begin
   case TMMSpeedButton(Sender).Tag of
        1: try
              Channel1.Play;
           finally
              btnPlay1.Down := Channel1.Playing;
              if btnPlay1.Down then btnPause1.Down := False;
           end;
        2: try
              Channel2.Play;
           finally
              btnPlay2.Down := Channel2.Playing;
              if btnPlay2.Down then btnPause2.Down := False;
           end;
        3: try
              Channel3.Play;
           finally
              btnPlay3.Down := Channel3.Playing;
              if btnPlay3.Down then btnPause3.Down := False;
           end;
        4: try
              Channel4.Play;
           finally
              btnPlay4.Down := Channel4.Playing;
              if btnPlay4.Down then btnPause4.Down := False;
           end;
        5: try
              Channel5.Play;
           finally
              btnPlay5.Down := Channel5.Playing;
              if btnPlay5.Down then btnPause5.Down := False;
           end;
   end;
end;

{-- TMainForm -----------------------------------------------------------}
procedure TMainForm.btnPauseClick(Sender: TObject);
begin
   case TMMSpeedButton(Sender).Tag of
        1: begin
              if Channel1.Playing then
              begin
                 btnPause1.Down := True;
                 btnPlay1.Down := False;
                 Channel1.Pause;
              end
              else if Channel1.Paused then btnPause1.Down := True
              else btnPause1.Down := False;
           end;
        2: begin
              if Channel2.Playing then
              begin
                 btnPause2.Down := True;
                 btnPlay2.Down := False;
                 Channel2.Pause;
              end
              else if Channel2.Paused then btnPause2.Down := True
              else btnPause2.Down := False;
           end;
        3: begin
              if Channel3.Playing then
              begin
                 btnPause3.Down := True;
                 btnPlay3.Down := False;
                 Channel3.Pause;
              end
              else if Channel3.Paused then btnPause3.Down := True
              else btnPause3.Down := False;
           end;
        4: begin
              if Channel4.Playing then
              begin
                 btnPause4.Down := True;
                 btnPlay4.Down := False;
                 Channel4.Pause;
              end
              else if Channel4.Paused then btnPause4.Down := True
              else btnPause4.Down := False;
           end;
        5: begin
              if Channel5.Playing then
              begin
                 btnPause5.Down := True;
                 btnPlay5.Down := False;
                 Channel5.Pause;
              end
              else if Channel5.Paused then btnPause5.Down := True
              else btnPause5.Down := False;
           end;
   end;
end;

{-- TMainForm -----------------------------------------------------------}
procedure TMainForm.btnStopClick(Sender: TObject);
begin
   case TMMSpeedButton(Sender).Tag of
        1: begin
              Channel1.Stop;
              btnPlay1.Down := False;
              btnPause1.Down := False;
           end;
        2: begin
              Channel2.Stop;
              btnPlay2.Down := False;
              btnPause2.Down := False;
           end;
        3: begin
              Channel3.Stop;
              btnPlay3.Down := False;
              btnPause3.Down := False;
           end;
        4: begin
              Channel4.Stop;
              btnPlay4.Down := False;
              btnPause4.Down := False;
           end;
        5: begin
              Channel5.Stop;
              btnPlay5.Down := False;
              btnPause5.Down := False;
           end;
   end;
end;

{-- TMainForm -----------------------------------------------------------}
procedure TMainForm.btnMuteClick(Sender: TObject);
begin
   case TMMSpeedButton(Sender).Tag of
        1: Channel1.Muted := not Channel1.Muted;
        2: Channel2.Muted := not Channel2.Muted;
        3: Channel3.Muted := not Channel3.Muted;
        4: Channel4.Muted := not Channel4.Muted;
        5: Channel5.Muted := not Channel5.Muted;
   end;
end;

{-- TMainForm -----------------------------------------------------------}
procedure TMainForm.btnLoopClick(Sender: TObject);
begin
   case TMMSpeedButton(Sender).Tag of
        1: Channel1.Looping := not Channel1.Looping;
        2: Channel2.Looping := not Channel2.Looping;
        3: Channel3.Looping := not Channel3.Looping;
        4: Channel4.Looping := not Channel4.Looping;
        5: Channel5.Looping := not Channel5.Looping;
   end;
end;

{-- TMainForm -----------------------------------------------------------}
procedure TMainForm.btnAutoClick(Sender: TObject);
begin
;
end;

{-- TMainForm -----------------------------------------------------------}
procedure TMainForm.trackVolumeChange(Sender: TObject);
begin
   case TTrackBar(Sender).Tag of
        1: Channel1.Volume := (TTrackBar(Sender).Position+(-400))*10;
        2: Channel2.Volume := (TTrackBar(Sender).Position+(-400))*10;
        3: Channel3.Volume := (TTrackBar(Sender).Position+(-400))*10;
        4: Channel4.Volume := (TTrackBar(Sender).Position+(-400))*10;
        5: Channel5.Volume := (TTrackBar(Sender).Position+(-400))*10;
   end;
end;

{-- TMainForm -----------------------------------------------------------}
procedure TMainForm.trackPanChange(Sender: TObject);
begin
   case TTrackBar(Sender).Tag of
        1: Channel1.Panning := (TTrackBar(Sender).Position+(-500))*20;
        2: Channel2.Panning := (TTrackBar(Sender).Position+(-500))*20;
        3: Channel3.Panning := (TTrackBar(Sender).Position+(-500))*20;
        4: Channel4.Panning := (TTrackBar(Sender).Position+(-500))*20;
        5: Channel5.Panning := (TTrackBar(Sender).Position+(-500))*20;
   end;
end;

{-- TMainForm -----------------------------------------------------------}
procedure TMainForm.trackFreqChange(Sender: TObject);
begin
   case TTrackBar(Sender).Tag of
        1: Channel1.Frequency := TTrackBar(Sender).Position;
        2: Channel2.Frequency := TTrackBar(Sender).Position;
        3: Channel3.Frequency := TTrackBar(Sender).Position;
        4: Channel4.Frequency := TTrackBar(Sender).Position;
        5: Channel5.Frequency := TTrackBar(Sender).Position;
   end;
end;

{-- TMainForm -----------------------------------------------------------}
procedure TMainForm.trackPositionChange(Sender: TObject);
begin
   case TTrackBar(Sender).Tag of
        1: Channel1.Position := TTrackBar(Sender).Position * 1024;
        2: Channel2.Position := TTrackBar(Sender).Position * 1024;
        3: Channel3.Position := TTrackBar(Sender).Position * 1024;
        4: Channel4.Position := TTrackBar(Sender).Position * 1024;
        5: Channel5.Position := TTrackBar(Sender).Position * 1024;
   end;
end;

{-- TMainForm -----------------------------------------------------------}
procedure TMainForm.Timer1Timer(Sender: TObject);
begin
  trackPosition1.Position := Channel1.Position div 1024;
  trackPosition2.Position := Channel2.Position div 1024;
  trackPosition3.Position := Channel3.Position div 1024;
  trackPosition4.Position := Channel4.Position div 1024;
  trackPosition5.Position := Channel5.Position div 1024;
end;

end.
